import java.util.Arrays;
import java.util.LinkedList;
import java.util.Scanner;


public class Main {

	static boolean[] used = new boolean[20000];
	static int[] curweight = new int[20000];
	static LinkedList[] ways = new LinkedList[20000];
	static Backtrack[] from_a = new Backtrack[20000];
	
	static class Road_to {
		public int path;
		public int weight;
		public int index;
		public Road_to(int path, int weight, int index) {
			this.path = path;
			this.weight = weight;
			this.index = index;
		}
	}
	
	static class Backtrack {
		public int from;
		public int index;
		public Backtrack(int from, int index) {
			this.from = from;
			this.index = index;
		}
	}
	
	static int n, m;
	
	static void find(int from, int excl) {
		for (Object v : ways[from]) {
			if (((Road_to)v).index == excl) continue;
			int i = ((Road_to)v).path;
			if (curweight[from] + ((Road_to)v).weight < curweight[i]) {
				curweight[i] =curweight[from] + ((Road_to)v).weight;
				if (excl == -1) from_a[i] = new Backtrack(from, ((Road_to)v).index);
			}
			
		}
		used[from] = true;
		for (int i=0; i<n; ++i) {
			if (!used[i]) find(i, excl);
		}
	}
	
	public static void main(String[] args) {
		Scanner in = new Scanner(System.in);
		
		for (int i=0;i<20000;++i) ways[i] = new LinkedList();
		n = in.nextInt();
		m = in.nextInt();
		for (int i=0;i<m;++i) {
			int from = in.nextInt();
			int to = in.nextInt();
			ways[from-1].add(new Road_to(to-1, in.nextInt(), i));
		}
		Arrays.fill(used, false);
		Arrays.fill(curweight, Integer.MAX_VALUE);
		curweight[0]=0;
		find(0, -1);
		int minw = curweight[n-1];
		
		LinkedList exclroads = new LinkedList();
		int ix = n-1;
		while (ix != 0) {
			if (from_a[ix] == null) {
				System.out.println(0);
				return;
			}
			exclroads.add(Integer.valueOf(from_a[ix].index));
			ix = from_a[ix].from;
		}
		
		LinkedList important = new LinkedList();
		for (Object obj : exclroads) {
			int i = ((Integer)obj).intValue();
			Arrays.fill(used, false);
			Arrays.fill(curweight, Integer.MAX_VALUE);
			curweight[0]=0;
			find(0, i);
			if (curweight[n-1] > minw) important.add(Integer.valueOf(i+1));
		}
		
		System.out.println(important.size());
		for (Object i : important) {
			System.out.print(i);
			System.out.print(" ");
		}
		System.out.println();
	}

}
